using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class MetaCriterionResponse
{
    public static readonly string DataItem = "criterion";

    [JsonProperty("browser")]
    public Criterion Browser { get; set; }

    [JsonProperty("clicks")]
    public Criterion Clicks { get; set; }

    [JsonProperty("country")]
    public Criterion Country { get; set; }

    [JsonProperty("date")]
    public Criterion Date { get; set; }

    [JsonProperty("ip")]
    public Criterion Ip { get; set; }

    [JsonProperty("language")]
    public Criterion Language { get; set; }

    [JsonProperty("platform")]
    public Criterion Platform { get; set; }

    [JsonProperty("regexp")]
    public Criterion Regexp { get; set; }

    [JsonProperty("time")]
    public Criterion Time { get; set; }

    public class Criterion
    {
        [JsonProperty("name")]
        public string Name { get; set; }

        [JsonProperty("options")]
        public string Options { get; set; }
    }
}
